<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_recharge_competitions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('competition_period'); // 'daily', 'weekly', 'monthly'
            $table->date('period_start');
            $table->date('period_end');
            $table->decimal('total_recharged', 12, 2)->default(0); // Total amount recharged in this period
            $table->integer('total_diamonds')->default(0); // Total diamonds purchased
            $table->integer('transaction_count')->default(0); // Number of transactions
            $table->integer('current_tier')->default(1); // Current tier (1=Bronze, 2=Silver, 3=Gold, 4=Platinum, 5=Diamond)
            $table->integer('points_earned')->default(0); // Competition points
            $table->json('achievements')->nullable(); // Earned achievements
            $table->json('rewards_claimed')->nullable(); // Claimed rewards
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index(['user_id', 'competition_period']);
            $table->index(['period_start', 'period_end']);
            $table->unique(['user_id', 'competition_period', 'period_start']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_recharge_competitions');
    }
};
