<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('recharge_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transaction_id')->unique(); // From payment provider
            $table->unsignedBigInteger('user_id')->nullable(); // User ID from your system
            $table->string('user_name');
            $table->string('user_email');
            $table->string('user_phone')->nullable();
            $table->string('payment_method'); // 'paypal', 'vodafone', 'instapay'
            $table->decimal('amount', 10, 2); // Original amount user wanted to recharge
            $table->decimal('fee', 10, 2); // Processing fee
            $table->decimal('total_amount', 10, 2); // Total amount charged
            $table->string('currency', 3);
            $table->integer('diamonds_purchased'); // Diamonds the user should receive
            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('pending');
            $table->text('note')->nullable(); // User's note
            $table->json('payment_details')->nullable(); // Additional payment info
            $table->timestamp('payment_date')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'status']);
            $table->index(['payment_method', 'status']);
            $table->index('transaction_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recharge_transactions');
    }
};
