<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('recharge_settings', function (Blueprint $table) {
            $table->id();
            $table->string('payment_method'); // 'paypal', 'vodafone', 'instapay'
            $table->boolean('is_active')->default(true);
            $table->decimal('fee_percentage', 5, 3); // Processing fee percentage (e.g., 3.500 for 3.5%)
            $table->decimal('minimum_amount', 10, 2); // Minimum amount for this payment method
            $table->decimal('maximum_amount', 10, 2)->nullable(); // Maximum amount (optional)
            $table->string('currency', 3); // 'USD', 'EGP'
            $table->decimal('diamond_rate', 10, 4); // How many diamonds per unit currency
            $table->string('phone_number')->nullable(); // For Vodafone/InstaPay
            $table->string('paypal_username')->nullable(); // For PayPal
            $table->json('additional_settings')->nullable(); // For any extra settings
            $table->timestamps();

            $table->unique('payment_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recharge_settings');
    }
};
