<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('recharge_rewards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // User who received the reward
            $table->unsignedBigInteger('recharge_transaction_id'); // Related transaction
            $table->unsignedBigInteger('reward_setting_id'); // Which tier reward
            $table->string('reward_type'); // 'diamonds', 'item', 'vip_days', 'bonus_percentage'
            $table->string('reward_name'); // Name of the reward
            $table->decimal('reward_value', 15, 2); // Value (amount of diamonds, days, etc.)
            $table->text('reward_description')->nullable();
            $table->enum('status', ['pending', 'claimed', 'expired'])->default('pending');
            $table->timestamp('expires_at')->nullable();
            $table->timestamp('claimed_at')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'status']);
            $table->index(['recharge_transaction_id']);
            $table->index(['reward_setting_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('recharge_rewards');
    }
};
