<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('recharge_rewards_settings', function (Blueprint $table) {
            $table->id();
            $table->string('tier_name'); // Bronze, Silver, Gold, Diamond, Elite
            $table->decimal('minimum_amount', 10, 2); // Minimum total recharge amount to reach this tier
            $table->json('rewards'); // JSON array of rewards (diamonds, items, etc.)
            $table->string('tier_color')->default('#8B5CF6'); // Color for UI display
            $table->string('tier_icon')->default('🏆'); // Emoji icon for the tier
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('recharge_rewards_settings');
    }
};
