<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->use([
            \App\Http\Middleware\TrustProxies::class,
            \App\Http\Middleware\SetApplicationLanguage::class,
            \App\Http\Middleware\HandleLivewireErrors::class,
        ]);

        $middleware->web(append: [
            \App\Http\Middleware\LoadUserSessionData::class,
        ]);

        // Register team level middleware
        $middleware->alias([
            'team.level' => \App\Http\Middleware\CheckTeamLevel::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
