<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use App\Auth\MD5UserProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Force HTTPS URLs in production and when HTTPS is detected
        if (config('app.env') === 'production' ||
            request()->isSecure() ||
            request()->header('X-Forwarded-Proto') === 'https' ||
            env('FORCE_HTTPS', false)) {
            URL::forceScheme('https');
        }

        // Register MD5 User Provider
        Auth::provider('md5_eloquent', function ($app, array $config) {
            return new \App\Auth\MD5EloquentUserProvider($app['hash'], $config['model']);
        });

        // Register custom pagination view
        \Illuminate\Pagination\Paginator::defaultView('pagination.custom');
    }
}
