<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserVote extends Model
{
    use HasFactory;

    protected $fillable = [
        'vote_site_id',
        'user_id',
        'last_vote_time',
        'next_vote_time',
        'postback_received',
        'postback_data',
        'postback_received_at'
    ];

    protected $casts = [
        'postback_data' => 'array',
        'last_vote_time' => 'datetime',
        'next_vote_time' => 'datetime',
        'postback_received_at' => 'datetime',
        'postback_received' => 'boolean',
    ];

    public function voteSite()
    {
        return $this->belongsTo(VoteSite::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
