<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserRole extends Model
{
    use HasFactory;

    protected $connection = 'sqlsrv';

    protected $fillable = ['name', 'level', 'description'];

    /**
     * العلاقة مع المستخدمين
     * دور واحد يمكن أن يكون له مستخدمين متعددين
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany(User::class, 'role_id');
    }
}
