<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPermission extends Model
{
    use HasFactory;


    protected $fillable = [
        'JID',
        'username',
        'canvisitall',
        'pages',
    ];

    protected $casts = [
        'canvisitall' => 'boolean',
        'pages' => 'array', // تحويل الـ JSON تلقائيًا لمصفوفة
    ];

    // علاقة مع المستخدم
    public function user()
    {
        return $this->belongsTo(User::class, 'JID', 'JID');
    }
}
