<?php

namespace App\Models\Z_Website;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Models\SRO_VT_ACCOUNT\TbUser;
use App\Models\SRO_VT_ACCOUNT\SkSilk;
use App\Models\SRO_VT_PROXY\_Players;
use App\Models\Z_Website\CharGold;
use App\Models\Z_Website\Charging\{ChargingUserRecharge,ChargingRechargeProgress,ChargingPaypalTransaction,ChargingPaymentLog};
use App\Models\Z_Website\Quests\TasksUserReward;
use App\Models\Z_Website\Quests\TaskUserVipStatus;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    protected $connection = 'sqlsrv';
    /**
     * المفتاح الأساسي للجدول
     *
     * @var string
     */
    protected $primaryKey = 'JID';

    /**
     * تعطيل auto-increment لأن JID ليس auto-increment
     *
     * @var bool
     */
    public $incrementing = false;

    /**
     * تحديد نوع المفتاح الأساسي
     *
     * @var string
     */
    protected $keyType = 'int';

    /**
     * تعطيل الـ timestamps
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'JID',
        'username',
        'picture',
        'banner',
        'balance',
        'gift_balance',
        'facebook',
        'youtube',
        'discord',
        'Active',
        'Likes',
        'Report',
        'thanks',
        'Posts',
        'BrokenRules',
        'About',
        'Hobbies',
        'ShowPhone',
        'ShowEmail',
        'is_dark',
        'lang',
        'referrer_id',
        'role_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'ShowPhone' => 'boolean',
            'ShowEmail' => 'boolean',
            'is_dark' => 'boolean',
        ];
    }

    /**
     * العلاقة مع TbUser (جدول المستخدمين الرئيسي في اللعبة)
     * هذه العلاقة تربط بين مستخدم الموقع ومستخدم اللعبة
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function tbUser()
    {
        return $this->belongsTo(TbUser::class, 'JID', 'JID');
    }

    /**
     * العلاقة مع SkSilk (جدول السيلك في اللعبة)
     * هذه العلاقة تجلب معلومات السيلك الخاصة بالمستخدم
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function silk()
    {
        return $this->belongsTo(SkSilk::class, 'JID', 'JID');
    }

    /**
     * العلاقة مع CharGold (جدول الذهب في الموقع)
     * هذه العلاقة تجلب معلومات الذهب الخاصة بالمستخدم
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function gold()
    {
        return $this->hasOne(CharGold::class, 'user_id', 'JID');
    }

    /**
     * المرجع (Referrer)
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function referrer()
    {
        return $this->belongsTo(__CLASS__, 'referrer_id', 'JID');
    }

    /**
     * الإحالات (Referrals)
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function referrals()
    {
        return $this->hasMany(__CLASS__, 'referrer_id', 'JID');
    }

    /**
     * العلاقة مع جدول اللاعبين النشطين
     * تربط بين مستخدم الموقع واللاعب النشط في اللعبة
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function player()
    {
        return $this->hasOne(_Players::class, 'StrUserID', 'username');
    }
    // ==============================================
    // ACCESSOR METHODS (خصائص مباشرة)
    // ==============================================

    /**
     * Accessor لاستدعاء StrUserID مباشرة من Auth::user()
     */
    public function getStrUserIDAttribute()
    {
        return $this->tbUser ? $this->tbUser->StrUserID : null;
    }

    /**
     * Accessor لاستدعاء Email مباشرة من Auth::user()
     */
    public function getEmailAttribute()
    {
        return $this->tbUser ? $this->tbUser->Email : null;
    }

    /**
     * Accessor لجلب silk_own من SkSilk مباشرة
     */
    public function getSilkOwnAttribute()
    {
        return $this->silk ? $this->silk->silk_own : 0;
    }

    /**
     * Accessor لاستدعاء Gift Silk
     */
    public function getSilkGiftAttribute()
    {
        return $this->silk ? $this->silk->silk_gift : 0;
    }

    /**
     * Accessor لجلب Silk Point
     */
    public function getSilkPointAttribute()
    {
        return $this->silk ? $this->silk->silk_point : 0;
    }

    // ==============================================
    // CHARGING & PAYMENT RELATIONS
    // ==============================================

    public function recharges()
    {
        return $this->hasMany(ChargingUserRecharge::class, 'user_id');
    }

public function rechargeProgress()
{
    return $this->hasMany(ChargingRechargeProgress::class, 'user_id');
}

public function paypalTransactions()
{
    return $this->hasMany(ChargingPaypalTransaction::class, 'user_id');
}

public function paymentLogs()
{
    return $this->hasMany(ChargingPaymentLog::class, 'user_id');
}


public function role()
{
    return $this->belongsTo(UserRole::class, 'role_id');
}



public function scopeSearch($query, $search)
{
    return $query->where('name', 'like', "%{$search}%")
                 ->orWhere('email', 'like', "%{$search}%");
}


 // علاقة بالمكافآت المستلمة
 public function rewards()
 {
     return $this->hasMany(TasksUserReward::class, 'user_id');
 }

    // التأكد من العلاقات مع جدول VIP Status
    public function vipStatus()
    {
        return $this->hasOne(TaskUserVipStatus::class, 'user_id');
    }

    // التحقق إذا كان المستخدم VIP
    public function isVip()
    {
        $vipStatus = $this->vipStatus;
        return $vipStatus && $vipStatus->is_vip;
    }

    /**
     * تحديد ما إذا كان المستخدم لديه دور معين
     *
     * @param string $roleName
     * @return bool
     */
    public function hasRole(string $roleName): bool
    {
        return $this->role && $this->role->name === $roleName;
    }

    /**
     * تحديد ما إذا كان المستخدم لديه مستوى دور معين أو أعلى
     *
     * @param int $level
     * @return bool
     */
    public function hasRoleLevel(int $level): bool
    {
        return $this->role && $this->role->level >= $level;
    }

    /**
     * الحصول على اسم الدور
     *
     * @return string|null
     */
    public function getRoleName(): ?string
    {
        return $this->role?->name;
    }

    /**
     * تحديد ما إذا كان المستخدم admin
     *
     * @return bool
     */
    public function isAdmin(): bool
    {
        return $this->hasRole('admin') || $this->hasRoleLevel(100);
    }
}
