<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Model;

class SiteSettings extends Model
{
    /**
     * @var array
     */
    protected $fillable = [
        'settings', 'theme'
    ];

    /**
     * @var array
     */
    protected $casts = [
        'settings' => 'array',
    ];

    /**
     * @var bool
     */
    public $timestamps = false;


        /**
     * العلاقة بين `SiteSettings` و `SiteSettingsTheme`
     */
    public function themeRelation()
    {
        return $this->belongsTo(SiteSettingsTheme::class, 'theme', 'name');
    }
}
