<?php

namespace App\Models\Z_Website\Quests;

use App\Models\Z_Website\User;
use Illuminate\Database\Eloquent\Model;

class TasksUserReward extends Model
{
    protected $table = 'tasks_user_rewards';
    protected $fillable = ['user_id', 'reward_id', 'reward_type', 'is_claimed'];

    // علاقة بالمستخدم
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // علاقة بالمكافآت
    public function reward()
    {
        return $this->belongsTo(TaskReward::class, 'reward_id');
    }

    //getUserReward
    public static function getUserReward($userId)
    {
        return self::where('user_id', $userId)->with('reward')->get();
    }
}
