<?php

namespace App\Models\Z_Website\Quests;

use App\Models\SRO_VT_SHARD\_User;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\Z_Website\User;
use Illuminate\Database\Eloquent\Model;


class TaskUserVipStatus extends Model
{
    // اسم الجدول
    protected $table = 'tasks_user_vip_status';

    // الأعمدة القابلة للتعبئة
    protected $fillable = [
        'user_id',     // معرف المستخدم
        'CharID',
        'is_vip',      // حالة VIP
    ];

    // الكاست للتحويل التلقائي
    protected $casts = [
        'is_vip' => 'boolean', // تحويل الحقل لقيمة Boolean
    ];

    /**
     * العلاقة مع المستخدم
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function char()
    {
        return $this->belongsTo(Char::class, 'CharID', 'CharID');
    }
    public static function currentChar($userId)
    {
        return self::where('user_id', $userId)->with('char')->first();
    }
    /**
     * التحقق مما إذا كان المستخدم VIP
     */
    public function isVip()
    {
        return $this->is_vip;
    }

    public static function getAvailableChars($userId)
    {
    // جلب الشخصية الحالية للمستخدم
    $currentChar = self::where('user_id', $userId)->pluck('CharID')->first();

    // جلب كل الشخصيات المرتبطة بالمستخدم
    $charIDs = _User::where('UserJID', $userId)->pluck('CharID');

    // لو مفيش شخصيات مرتبطة
    if ($charIDs->isEmpty()) {
        return collect();  // إرجاع Collection فارغة
    }

    // جلب أسماء الشخصيات من جدول _Char مع استبعاد الشخصية الحالية
    return Char::whereIn('CharID', $charIDs)
        ->where('CharID', '!=', $currentChar) // استبعاد الشخصية الحالية
        ->select('CharID', 'CharName16', 'RefObjID', 'CurLevel')
        ->get();
    }

    //check if user have char usercharid back with CharID
    public static function usercharid($userId)
    {
        $record = self::where('user_id', $userId)->first();

        // Check if record exists and has a CharID
        if (!$record || !$record->CharID) {
            return null;
        }

        $char = Char::where('CharID', $record->CharID)
            ->select('CharID', 'CharName16', 'RefObjID')
            ->first();

        // Add isVip property to character object
        if ($char) {
            $char->isVip = $record->is_vip;
        }

        return $char;
    }
}
