<?php

namespace App\Models\Z_Website\Quests;

use App\Models\Z_Website\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;


class TaskUserProgress extends Model
{
    protected $table = 'tasks_user_progress';

    protected $fillable = ['user_id', 'start_date'];

    protected $casts = [
        'start_date' => 'date',
        'day_1' => 'boolean',
        'day_2' => 'boolean',
        'day_3' => 'boolean',
        'day_4' => 'boolean',
        'day_5' => 'boolean',
        'day_6' => 'boolean',
        'day_7' => 'boolean',
        'day_8' => 'boolean',
        'day_9' => 'boolean',
        'day_10' => 'boolean',
        'day_11' => 'boolean',
        'day_12' => 'boolean',
        'day_13' => 'boolean',
        'day_14' => 'boolean',
        'day_15' => 'boolean',
        'day_16' => 'boolean',
        'day_17' => 'boolean',
        'day_18' => 'boolean',
        'day_19' => 'boolean',
        'day_20' => 'boolean',
        'day_21' => 'boolean',
        'day_22' => 'boolean',
        'day_23' => 'boolean',
        'day_24' => 'boolean',
        'day_25' => 'boolean',
        'day_26' => 'boolean',
        'day_27' => 'boolean',
        'day_28' => 'boolean',
        'day_29' => 'boolean',
        'day_30' => 'boolean',
        'day_31' => 'boolean',
    ];

    /**
     * ربط بالمستخدم
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


    public function getCompletedDays()
{
    $completedDays = [];
    foreach (range(1, 31) as $day) {
        if ($this->{'day_' . $day}) {
            $completedDays[] = $day;
        }
    }
    return $completedDays;
}

public function isDayCompleted($day)
{
        // التأكد من صحة رقم اليوم
    if ($day < 1 || $day > 31) {
        return false; // إرجاع false للأرقام غير الصحيحة
    }
    return $this->{'day_' . $day} ?? false;
}

public function completeDay($day)
{
    $this->{'day_' . $day} = true;
    $this->save();
}

/**
 * Mark a specific day as completed (alias for completeDay)
 */
public function markDayCompleted($day)
{
    // التأكد من صحة رقم اليوم
    if ($day < 1 || $day > 31) {
        Log::warning('Invalid day number provided to markDayCompleted', [
            'day' => $day,
            'user_id' => $this->user_id
        ]);
        return false;
    }

    $dayField = 'day_' . $day;
    $this->{$dayField} = true;
    $this->save();

    Log::info('Day marked as completed in TaskUserProgress', [
        'user_id' => $this->user_id,
        'day' => $day,
        'field' => $dayField,
        'value' => true
    ]);

    return true;
}
public function countCompletedDays()
{
    // جمع الأيام التي قيمتها `true`
    $totalCompletedDays = 0;
    foreach (range(1, 31) as $day) {
        if ($this->{'day_' . $day}) {
            $totalCompletedDays++;
        }
    }
    return $totalCompletedDays;
}

/**
 * دالة محسّنة لحساب إجمالي الأيام المكتملة
 * تستخدم طريقة أكثر كفاءة لحساب القيم الصحيحة
 */
public function getTotalCompletedDays()
{
    $completedCount = 0;

    // التكرار عبر جميع أعمدة الأيام وحساب المكتمل منها
    for ($day = 1; $day <= 31; $day++) {
        $dayColumn = 'day_' . $day;
        if ($this->{$dayColumn}) {
            $completedCount++;
        }
    }

    return $completedCount;
}

/**
 * دالة لحساب النسبة المئوية للتقدم (من 31 يوم)
 */
public function getProgressPercentage()
{
    $completedDays = $this->getTotalCompletedDays();
    return round(($completedDays / 31) * 100, 2);
}

/**
 * دالة للحصول على احصائيات شاملة للتقدم
 */
public function getProgressStats()
{
    $totalCompleted = $this->getTotalCompletedDays();
    $totalDays = 31;
    $remainingDays = $totalDays - $totalCompleted;
    $progressPercentage = $this->getProgressPercentage();

    return [
        'total_completed' => $totalCompleted,
        'total_days' => $totalDays,
        'remaining_days' => $remainingDays,
        'progress_percentage' => $progressPercentage,
        'is_complete' => $totalCompleted >= $totalDays
    ];
}

//getUserProgress by UserJID  get line record
public static function getUserProgress($userJID)
{
    return self::where('user_id', $userJID)->first();
}



}
