<?php

namespace App\Models\Z_Website\Quests;

use Illuminate\Database\Eloquent\Model;

class TaskRewardChain extends Model
{
    protected $table = 'tasks_reward_chains';
    protected $fillable = [
        'days_required',
        'normal_reward',
        'vip_reward',
        'reward_description',
    ];

    /**
     * تحويل القيم للأنواع المناسبة
     */
    protected $casts = [
        'days_required' => 'integer',
        'normal_reward' => 'integer',
        'vip_reward' => 'integer',
        'reward_description' => 'string',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    public function normalReward()
    {
        return $this->belongsTo(TaskReward::class, 'normal_reward');
    }

    public function vipReward()
    {
        return $this->belongsTo(TaskReward::class, 'vip_reward');
    }

    public static function getAllRewards()
    {
        return self::with(['normalReward', 'vipReward'])->orderBy('days_required', 'asc')->get();
    }
}
