<?php

namespace App\Models\Z_Website\Quests;

use Illuminate\Database\Eloquent\Model;

class TaskDailyTask extends Model
{
    protected $table = 'tasks_daily_tasks';

    protected $primaryKey = 'id';
    protected $fillable = ['task_name', 'QuestID', 'duration_seconds', 'task_image'];

    /**
     * ربط بالمهام المرتبطة بالمستخدم
     */
    public function userTasks()
    {
        return $this->hasMany(TaskUserDailyTask::class, 'task_id');
    }

    // Get Task Details by ID
    public static function getTaskDetails($taskId)
    {
        return self::where('id', $taskId)->first();
    }


}
