<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Z_Website\User;

class NtfNotificationUser extends Model
{
    protected $fillable = [
        'user_id',
        'notification_id',
    ];

    /**
     * العلاقة مع المستخدم
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'JID');
    }

    /**
     * العلاقة مع الإشعار
     */
    public function notification(): BelongsTo
    {
        return $this->belongsTo(NtfNotification::class, 'notification_id');
    }
}
