<?php

namespace App\Models\Z_Website\Market;

use App\Models\Z_Website\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MarketPlayerLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'from_charid',
        'balance_type',
        'price',
        'user_id_buyer',
        'serial64',
        'item_id64',
        'state',
    ];

    /**
     * العلاقة مع المستخدم.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'JID');
    }

    /**
     * العلاقة مع اللاعب في MarketPlayer.
     */
    public function marketPlayer()
    {
        return $this->belongsTo(MarketPlayer::class, 'serial64', 'serial64');
    }
}
