<?php

namespace App\Models\Z_Website\Market;

use App\Models\SRO_VT_PROXY\_Players;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\SRO_VT_SHARD\Inventory;
use App\Models\SRO_VT_SHARD\_User;
use App\Models\SRO_VT_SHARD\Items;
use App\Models\Z_Website\User;

class MarketPlayer extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'from_charid',
        'balance_type',
        'price',
        'serial64',
        'item_id64',
        'name',
        'imgpath',
        'optlevel',
        'amount',
        'special',
        'sort',
        'degree',
        'level',
        'npc_price',
        'race',
        'sex',
        'data',
    ];



    // ✅ العلاقة مع معلومات اللاعب من جدول _Players
    public function playerInfo()
    {
        return $this->belongsTo(_Players::class, 'from_charid', 'CharID');
    }

    // علاقة مع _Inventory

    /**
     * العلاقة مع المستخدم.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'JID');
    }

    /**
     * العلاقة مع السجلات (MarketPlayerLogs).
     */
    public function logs()
    {
        return $this->hasMany(MarketPlayerLog::class, 'serial64', 'serial64');
    }

    public function player()
    {
        return $this->belongsTo(User::class, 'user_id', 'jid');
    }
    public function item()
    {
        return $this->belongsTo(Items::class, 'item_id', 'id64'); // تأكد من الأعمدة
    }
}
