<?php

namespace App\Models\Z_Website\Market;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MarketItem extends Model
{
    use HasFactory;
    protected $table = 'market_items';
    public $timestamps = false;

    protected $primaryKey = 'id';

    protected $fillable = [
        'name',
        'description',
        'item_type',
        'balance_type',
        'price',
        'package_id',
        'stock',
        'image',
        'expiry_date',
        'RefItemID',   // معرف العنصر
        'CodeName128', // الكود الخاص بالعنصر
        'Count',       // العدد
        'json_data',
        'sort_order',
        'sort_type',
    ];

    protected $casts = [
        'json_data' => 'array',
        'expiry_date' => 'datetime',
    ];


}

