<?php

namespace App\Models\Z_Website\Logs;

use App\Models\SRO_VT_PROXY\_Players;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class LogGlobal extends Model
{
    use HasFactory;

    protected $table = 'log_globals';
    protected $fillable = ['char_name', 'msg', 'date'];
    public $timestamps = false;

    /**
     * علاقة تربط LogGlobal بـ _Players
     * ربط `char_name` مع `CharName16`
     */
    public function player()
    {
        return $this->hasOne(_Players::class, 'CharName', 'char_name');
    }
}
