<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiftLog extends Model
{
    use HasFactory;

    protected $table = 'gift_logs'; // اسم الجدول
    protected $primaryKey = 'id'; // المفتاح الأساسي

    protected $fillable = [
        'char_id', // CharID
        'CharName', // CharName
        'gift_id', // GiftID
        'reason', // السبب
        'send_to', // السبب
        'from_event',
        'send_by', // السبب
        'send_by_name', // السبب
    ];

    // العلاقة مع جدول gifts
    public function gift()
    {
        return $this->belongsTo(Gift::class, 'gift_id');
    }

}
