<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gift extends Model
{
    use HasFactory;

    protected $table = 'gifts'; // اسم الجدول
    protected $primaryKey = 'id'; // المفتاح الأساسي

    protected $fillable = [
        'name', // اسم الهدية
        'type', // نوع الهدية
        'CodeName128', // CodeName128
        'Count', // الكمية
    ];

    // العلاقة مع جدول gift_logs
    public function logs()
    {
        return $this->hasMany(GiftLog::class, 'gift_id');
    }
}
