<?php

namespace App\Models\Z_Website\Charging;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChargingRechargeProgress extends Model
{
    public $timestamps = false;
    use HasFactory;

    protected $fillable = ['user_id', 'amount', 'progress', 'target', 'last_recharge_at', 'completed_at'];

    public function giftDetails()
    {
        return $this->hasOne(ChargingGiftRange::class, 'progress_id');
    }
    public function giftRange()
{
    return $this->belongsTo(ChargingGiftRange::class, 'target', 'required_recharges');
}
}
