<?php

namespace App\Models\Z_Website\Charging;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChargingCode extends Model
{
    use HasFactory;
    public $timestamps = false;

    protected $fillable = ['status', 'JID', 'code', 'type', 'value', 'expires_at', 'accepted_at','accepted_by', 'used_at'];

    public function userRecharges()
    {
        return $this->hasMany(ChargingUserRecharge::class, 'code_id');
    }
    public function chargingRequest()
    {
        return $this->hasOne(ChargingRequest::class, 'charging_code', 'code');
    }
}
