<?php

namespace App\Models\Z_Website;

use Illuminate\Database\Eloquent\Model;

class CharGold extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id', 'gold'
    ];

    // ==============================================
    // RELATIONSHIPS
    // ==============================================

    /**
     * العلاقة العكسية مع User
     * كل ذهب ينتمي لمستخدم واحد
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'JID');
    }
}
