<?php

namespace App\Models\Z_A_BOTS_SYSTEMS;

use Illuminate\Database\Eloquent\Model;
use App\Models\Z_A_BOTS_SYSTEMS\EventBasicsRewards;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\SRO_VT_SHARD\_User;
use App\Models\SRO_VT_ACCOUNT\TbUser;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class EventPlayersRank extends Model
{
         /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_bots';
    protected $table = '___Events_Players_Rank';
    protected $primaryKey = 'CharID';  // المفتاح الأساسي الصحيح
    public $timestamps = false;

    protected $fillable = [
        'EventID',
        'EventName',
        'CharID',
        'Charname',
        'Hwid',
        'JobType',
        'Points',
        'StartEvent',
        'LastPoint',
        'Kills',
        'LastKill',
        'Death',
        'LastDeath',
        'Killedby'
    ];

        // تعريف العلاقة مع الجوائز
        public function reward()
        {
            return $this->hasOne(EventBasicsRewards::class, 'Toprank', 'Points')
                        ->whereColumn('EventID', 'EventID');
        }

        public function char()
        {
            return $this->hasOne(Char::class, 'CharID', 'CharID');
        }

        // العلاقة المحسنة مع المستخدم - نستخدم دالة بديلة
        public function user()
        {
            // نعيد علاقة فارغة لأن hasOneThrough لا يعمل مع connections مختلفة
            return $this->hasOne(TbUser::class, 'JID', 'CharID')->whereRaw('1 = 0'); // دائماً فارغة
        }

        // علاقة مباشرة مع _User للاختبار
        public function userAccount()
        {
            return $this->hasOneThrough(
                _User::class,          // النموذج المطلوب
                Char::class,           // النموذج الوسطي
                'CharID',              // Foreign key على الجدول الوسطي (Char.CharID)
                'CharID',              // Foreign key على النموذج المطلوب (_User.CharID)
                'CharID',              // Local key على النموذج الحالي (EventPlayersRank.CharID)
                'CharID'               // Local key على الجدول الوسطي (Char.CharID)
            );
        }

        // دالة مساعدة للحصول على TbUser بطريقة آمنة - هذه هي الدالة الرئيسية
        public function getTbUser()
        {
            try {
                $char = $this->char;
                if (!$char) {
                    return null;
                }

                $user = $char->getAccountUser;
                if (!$user || !$user->UserJID) {
                    return null;
                }

                return TbUser::where('JID', $user->UserJID)->first();
            } catch (\Exception $e) {
                Log::warning('Error getting TbUser: ' . $e->getMessage(), [
                    'char_id' => $this->CharID ?? 'unknown'
                ]);
                return null;
            }
        }

        // فحص إذا كانت الشخصية تخص المستخدم المسجل حالياً - نسخة محسنة وآمنة
        public function isOwned()
        {
            try {
                // فحص أولي للمستخدم المسجل
                if (!Auth::check()) {
                    return false;
                }

                // الحصول على المستخدم الحالي
                $currentUser = Auth::user();
                if (!$currentUser || !$currentUser->JID) {
                    return false;
                }

                // الحصول على TbUser للشخصية
                $playerTbUser = $this->getTbUser();
                if (!$playerTbUser || !$playerTbUser->JID) {
                    return false;
                }

                // مقارنة الـ JID
                return (int)$playerTbUser->JID === (int)$currentUser->JID;

            } catch (\Exception $e) {
                Log::warning('Error checking player ownership in model: ' . $e->getMessage(), [
                    'char_id' => $this->CharID ?? 'unknown',
                    'user_id' => Auth::id(),
                ]);
                return false;
            }
        }

        /**
         * فحص آمن لملكية الشخصية - النسخة المحسنة
         */
        public function isOwnedSafely()
        {
            if (!Auth::check()) {
                return false;
            }

            try {
                $currentUser = Auth::user();

                // فحص صحة بيانات المستخدم الحالي
                if (!$currentUser || !$currentUser->JID) {
                    return false;
                }

                // استخدام الدالة المحسنة للحصول على TbUser
                $playerTbUser = $this->getTbUser();

                if (!$playerTbUser || !$playerTbUser->JID) {
                    return false;
                }

                // مقارنة بسيطة ومباشرة
                return (int)$playerTbUser->JID === (int)$currentUser->JID;

            } catch (\Throwable $e) {
                Log::error('Critical error in isOwnedSafely: ' . $e->getMessage(), [
                    'char_id' => $this->CharID ?? 'unknown',
                    'user_id' => Auth::id(),
                    'trace' => $e->getTraceAsString()
                ]);
                return false;
            }
        }
}
