<?php

namespace App\Models\Z_A_BOTS_SYSTEMS;

use Illuminate\Database\Eloquent\Model;

class EventBasicsInfo extends Model
{
      /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_bots';

    protected $table = '_____Events_Basics___INFO';  // اسم الجدول
    protected $primaryKey = 'ID';  // مفتاح الجدول
    public $timestamps = false;  // الجدول لا يحتوي على created_at و updated_at

    protected $fillable = [
        'Active',
        'EventName',
        'NoticeType',
        'BotName',
        'Discord_Page',
        'Video_Link',
        'Page_Link',
        'Image_Link'
    ];


    // العلاقات
    public function timers()
    {
        return $this->hasMany(EventBasicsTimer::class, 'EventID', 'ID');
    }

    // العلاقة للحصول على التايمرز النشطة فقط (ضمن نطاق الوقت الحالي)
    public function activeTimers()
    {
        return $this->hasMany(EventBasicsTimer::class, 'EventID', 'ID')
            ->whereRaw('GETDATE() BETWEEN Start_Time AND End_Time');
    }

    public function ranks()
    {
        return $this->hasMany(EventPlayersRank::class, 'EventID', 'ID');
    }

    public function rewards()
    {
        return $this->hasMany(EventBasicsRewards::class, 'EventID', 'ID');
    }

    public function rules()
    {
        return $this->hasOne(EventRulesBasic::class, 'EventID', 'ID');
    }

    // دالة للتحقق من أن الإيفنت نشط ضمن الوقت المحدد
    public function isCurrentlyActive()
    {
        return $this->Active && $this->activeTimers()->exists();
    }

    // دالة للحصول على التايمر النشط حالياً
    public function getCurrentActiveTimer()
    {
        return $this->activeTimers()->orderBy('ID', 'desc')->first();
    }

}
