<?php

namespace App\Models\Z_A_BOTS_SYSTEMS;

use App\Models\SRO_VT_PROXY\_Players;
use App\Models\SRO_VT_SHARD\_User;
use App\Models\SRO_VT_SHARD\Char;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Event4TApp extends Model
{
    use HasFactory;

    protected $connection = 'sqlsrv_bots';  // الاتصال بقاعدة البيانات الخاصة بالبوتات
    protected $table = '____Event_4T_App';  // اسم الجدول
    protected $primaryKey = 'ID';  // المفتاح الأساسي للجدول
    public $timestamps = false;  // تعطيل الحقول الافتراضية لـ created_at و updated_at

    protected $fillable = [
        'CharID',
        'Charname',
        'Hwid',
        'Start',
    ];
    protected $dates = [
        'Start',
    ];
    protected $casts = [
        'Start' => 'datetime',
    ];




    // العلاقة مع جدول _Players
    public function player()
    {
        return $this->hasOne(_Players::class, 'Serial', 'Hwid');
    }


    // التاكد من ان الشخصية تعود للمستخدم الحالي باستخدام getCharnameByUser
    public static function isCharBelongsToUser($userJID)
    {
        // جلب كل CharID للمستخدم من جدول _User
        $charIDs = _User::where('UserJID', $userJID)->pluck('CharID');

        if ($charIDs->isEmpty()) {
            return false; // لو مفيش شخصيات مرتبطة نرجّع false
        }

        // العودة با CharID لو الشخصية موجودة الموجودة في جدول Event4TApp
        return self::whereIn('CharID', $charIDs)->exists();
    }

    //Check Count Chars for User
    public static function countCharsForUser($userJID)
    {
        // جلب كل CharID للمستخدم من جدول _User
        $charIDs = _User::where('UserJID', $userJID)->pluck('CharID');

        return $charIDs->count();
    }

    // دالة لحساب الوقت المتبقي للحدث
    // دالة لجلب الوقت المتبقي بناءً على UserJID
    public static function getRemainingTimeByUser($userJID)
    {
        // جلب كل CharID للمستخدم من جدول _User
        $charIDs = _User::where('UserJID', $userJID)->pluck('CharID');

        if ($charIDs->isEmpty()) {
            return 0; // لو مفيش شخصيات مرتبطة نرجّع صفر
        }

        // البحث عن أول حدث لم يحن بعد
        $event = self::whereIn('CharID', $charIDs)
            ->where('Start', '>', now())
            ->orderBy('Start')
            ->first();

        // حساب الفرق بالثواني
        if ($event) {
            $remainingTimeInSeconds = Carbon::now()->diffInSeconds(Carbon::parse($event->Start), false);

            // لو الفرق بالسالب نرجع صفر (يعني الحدث بدأ بالفعل)
            return $remainingTimeInSeconds > 0 ? $remainingTimeInSeconds : 0;
        }

        return 0; // لو مفيش حدث مستقبلي
    }

    // دالة لجلب أسماء الشخصيات المتاحة للمستخدم الحالي
    // دالة لجلب أسماء الشخصيات بناءً على UserJID
    public static function getAvailableChars($userJID)
    {
        // جلب كل CharID المرتبطة بالمستخدم
        $charIDs = _User::where('UserJID', $userJID)->pluck('CharID');

        // لو مفيش شخصيات مرتبطة
        if ($charIDs->isEmpty()) {
            return collect();  // إرجاع Collection فارغة
        }

        // جلب أسماء الشخصيات من جدول _Char مع RefObjID للافاتار
        return Char::whereIn('CharID', $charIDs)
            ->select('CharID', 'CharName16', 'RefObjID')
            ->get();
    }

    // Check getAvailableAnotherChars
    public static function getAvailableAnotherChars($userJID, $currentCharID)
    {
        // جلب كل CharID المرتبطة بالمستخدم
        $userCharIDs = _User::where('UserJID', $userJID)
            ->where('CharID', '!=', $currentCharID) // استثناء الشخصية الحالية
            ->pluck('CharID');

        // التحقق من الشخصيات المتصلة حالياً
        $onlineCharIDs = _Players::whereIn('CharID', $userCharIDs)
            ->where('cur_status', true)
            ->pluck('CharID');

        // لو مفيش شخصيات متصلة
        if ($onlineCharIDs->isEmpty()) {
            return collect();  // إرجاع Collection فارغة
        }

        // جلب أسماء الشخصيات من جدول _Char مع RefObjID للافاتار
        return Char::whereIn('CharID', $onlineCharIDs)
            ->select('CharID', 'CharName16', 'RefObjID')
            ->get()
            ->map(function ($char) {
                return [
                    'CharID' => $char->CharID,
                    'Charname' => $char->CharName16,
                    'RefObjID' => $char->RefObjID,
                    'Avatar' => Char::getCharAvatarGifByCharname($char->CharName16)
                ];
            });
    }

    //Check Exists Serial in Event4TApp by Serial
    public static function existsSerial($serial)
    {
        return self::where('Hwid', $serial)->exists();
    }

}
