<?php

namespace App\Models\SRO_VT_SHARD;

use App\Models\SRO_VT_ACCOUNT\SkSilk;
use App\Models\SRO_VT_ACCOUNT\TbUser;
use Illuminate\Database\Eloquent\Model;
use App\Models\SRO_VT_SHARD\Char;


class _User extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_shard';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo._User';

    /**
     * The table primary Key
     *
     * @var string
     */
    protected $primaryKey = 'CharID';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'CharID',
        'UserJID'
    ];


    public function getGuildMemberUser()
    {
        return $this->hasOne(Char::class, 'CharID', 'CharID');
    }

        /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getTbUser()
    {
        return $this->belongsTo(TbUser::class, 'UserJID', 'JID');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getSkSilk()
    {
        return $this->belongsTo(SkSilk::class, 'UserJID', 'JID');
    }

    /**
     * العلاقة مع الشخصيات
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function characters()
    {
        //Get CharIDs
        $charIds = $this->hasMany(Char::class, 'UserJID', 'JID')->pluck('CharID');
        return Char::whereIn('CharID', $charIds)->orderBy('CharID');
    }

    /**
     * علاقة مع _AccountJID
     * كل مستخدم له سجل ذهب واحد
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function accountJID()
    {
        return $this->hasOne(AccountJID::class, 'JID', 'UserJID');
    }



}
