<?php

namespace App\Models\SRO_VT_SHARD;

use Illuminate\Database\Eloquent\Model;

class MagOpt extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_shard';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo._MagOpt';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the primary key is auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = false;

    /**
     * The data type of the primary key.
     *
     * @var string
     */
    protected $keyType = 'int';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id',
        'name',
        'desc',
        'mLevel',
        'extension',
        'sortkey'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'mLevel' => 'integer',
        'sortkey' => 'integer',
        'name' => 'string',
        'desc' => 'string',
        'extension' => 'string',
    ];

    // =========================================================================
    // SCOPES
    // =========================================================================

    /**
     * Scope to order by sort key
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeOrderBySortKey($query)
    {
        return $query->orderBy('sortkey');
    }

    /**
     * Scope to filter by magic level
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param int $level
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeByLevel($query, $level)
    {
        return $query->where('mLevel', $level);
    }

    // =========================================================================
    // HELPER METHODS
    // =========================================================================

    /**
     * Get formatted description with value replacement
     *
     * @param int $value
     * @return string
     */
    public function getFormattedDescription($value)
    {
        return str_replace('%desc%', $value, $this->desc);
    }

    /**
     * Check if this is a durability related magic option
     *
     * @return bool
     */
    public function isDurabilityRelated()
    {
        return in_array($this->name, ['MATTR_DUR', 'MATTR_DEC_MAXDUR', 'MATTR_REPAIR']);
    }

    /**
     * Get color code for magic option display
     *
     * @return string
     */
    public function getColorCode()
    {
        return $this->name === 'MATTR_DEC_MAXDUR' ? 'ff2f51' : '50cecd';
    }
}
