<?php

namespace App\Models\SRO_VT_SHARD;

use Illuminate\Database\Eloquent\Model;
use App\Models\SRO_VT_SHARD\BindingOptionWithItem;
use App\Models\SRO_VT_SHARD\RefObjCommon;
use App\Models\SRO_VT_SHARD\Inventory;

class Items extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_shard';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo._Items';

    /**
     * The table primary Key
     *
     * @var string
     */
    protected $primaryKey = 'ID64';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'RefItemID',
        'OptLevel',
        'Variance',
        'Data',
        'CreaterName',
        'MagParamNum',
        'MagParam1',
        'MagParam2',
        'MagParam3',
        'MagParam4',
        'MagParam5',
        'MagParam6',
        'MagParam7',
        'MagParam8',
        'MagParam9',
        'MagParam10',
        'MagParam11',
        'MagParam12',
        'Serial64'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        // _Items table columns
        'ID64' => 'integer',
        'RefItemID' => 'integer',
        'OptLevel' => 'integer',
        'Variance' => 'integer',
        'Data' => 'integer',
        'CreaterName' => 'string',
        'MagParamNum' => 'integer',
        'MagParam1' => 'integer',
        'MagParam2' => 'integer',
        'MagParam3' => 'integer',
        'MagParam4' => 'integer',
        'MagParam5' => 'integer',
        'MagParam6' => 'integer',
        'MagParam7' => 'integer',
        'MagParam8' => 'integer',
        'MagParam9' => 'integer',
        'MagParam10' => 'integer',
        'MagParam11' => 'integer',
        'MagParam12' => 'integer',
        'Serial64' => 'integer',
    ];

    // =========================================================================
    // RELATIONSHIPS
    // =========================================================================

    /**
     * Get the reference object (item definition) for this item
     * RefItemID -> RefObjCommon.ID
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function refObjCommon()
    {
        return $this->belongsTo(RefObjCommon::class, 'RefItemID', 'ID');
    }

    /**
     * Get all inventory slots where this item is placed
     * ID64 -> Inventory.ItemID
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function inventorySlots()
    {
        return $this->hasMany(Inventory::class, 'ItemID', 'ID64');
    }

    /**
     * Get binding options for this item
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bindingOptions()
    {
        return $this->hasMany(BindingOptionWithItem::class, 'nItemDBID', 'ID64');
    }

    /**
     * Get active binding options for this item (nOptValue > 0)
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function activeBindingOptions()
    {
        return $this->bindingOptions()->where('nOptValue', '>', 0);
    }

    /**
     * @deprecated Use bindingOptions() or activeBindingOptions() instead
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bindingOption()
    {
        return $this->activeBindingOptions();
    }

    // =========================================================================
    // DEPRECATED METHODS (keeping for backward compatibility)
    // =========================================================================

    /**
     * @deprecated Use refObjCommon() instead
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getRefObjCommon()
    {
        return $this->refObjCommon();
    }

    /**
     * @deprecated Use refObjCommon() with select instead
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getRefObjCommonCanTrade()
    {
        return $this->refObjCommon()->select('ID', 'CanTrade');
    }

    /**
     * @deprecated Use bindingOption() instead
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getBindingOptionWithItem()
    {
        return $this->bindingOption();
    }

    // =========================================================================
    // HELPER METHODS
    // =========================================================================

    /**
     * Check if item has magic parameters
     *
     * @return bool
     */
    public function hasMagicParams()
    {
        return $this->MagParamNum > 0;
    }

    /**
     * Get all magic parameters as array
     *
     * @return array
     */
    public function getMagicParams()
    {
        $params = [];
        for ($i = 1; $i <= $this->MagParamNum && $i <= 12; $i++) {
            $paramName = "MagParam{$i}";
            if (!is_null($this->{$paramName})) {
                $params[] = $this->{$paramName};
            }
        }
        return $params;
    }

    /**
     * Check if item is enhanced (OptLevel > 0)
     *
     * @return bool
     */
    public function isEnhanced()
    {
        return $this->OptLevel > 0;
    }

    /**
     * Get enhancement level display (+1, +2, etc.)
     *
     * @return string
     */
    public function getEnhancementDisplay()
    {
        return $this->OptLevel > 0 ? "+{$this->OptLevel}" : "";
    }

    /**
     * Check if item has variance (randomized stats)
     *
     * @return bool
     */
    public function hasVariance()
    {
        return !is_null($this->Variance) && $this->Variance > 0;
    }

    // =========================================================================
    // SCOPES
    // =========================================================================

    /**
     * Scope to get only enhanced items (OptLevel > 0)
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeEnhanced($query)
    {
        return $query->where('OptLevel', '>', 0);
    }

    /**
     * Scope to get items with magic parameters
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeWithMagicParams($query)
    {
        return $query->where('MagParamNum', '>', 0);
    }

    /**
     * Scope to get items by specific RefItemID
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param int $refItemId
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeByRefItem($query, $refItemId)
    {
        return $query->where('RefItemID', $refItemId);
    }
}
