<?php

namespace App\Models\SRO_VT_SHARD;

use Illuminate\Database\Eloquent\Model;
use App\Models\SRO_VT_SHARD\Char;

class GuildMember extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_shard';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo._GuildMember';

    /**
     * The table primary Key
     *
     * @var string
     */
    protected $primaryKey = 'GuildID';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];

    /**
     * The attributes format for dates.
     *
     * @var array
     */
    protected $dates = [
        'JoinDate'
    ];

    protected $dateFormat = 'Y-m-d H:i:s';

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getCharItemPoints()
    {
        return $this->belongsTo(Char::class, 'CharID', 'CharID')
            ->select('CharID', 'ItemPoints');
    }

    /**
 * Get the character details associated with the guild member.
 *
 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
 */
public function character()
{
    return $this->belongsTo(Char::class, 'CharID', 'CharID')
        ->select('CharID', 'CharName16'); // بنختار CharID عشان التساوي و CharName16 عشان العرض
}

}
