<?php

namespace App\Models\SRO_VT_SHARD;

use Illuminate\Database\Eloquent\Model;
use App\Models\SRO_VT_SHARD\GuildMember;

class Guild extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_shard';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo._Guild';

    /**
     * The table primary Key
     *
     * @var string
     */
    protected $primaryKey = 'ID';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];

    /**
     * The attributes format for dates.
     *
     * @var array
     */
    protected $dates = [
        'FoundationDate'
    ];

    /**
     * @var string
     */
    protected $dateFormat = 'Y-m-d H:i:s';

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function getGuildMembers()
    {
        return $this->hasMany(GuildMember::class, 'GuildID', 'ID')        ->orderByRaw("
        CASE 
            WHEN SiegeAuthority = 1 THEN 1
            WHEN SiegeAuthority = 2 THEN 2
            WHEN SiegeAuthority = 4 THEN 3
            WHEN SiegeAuthority = 8 THEN 4
            WHEN SiegeAuthority = 16 THEN 5
            WHEN SiegeAuthority = 32 THEN 6
            ELSE 7 
        END
    ");;
    }
}
