<?php

namespace App\Models\SRO_VT_SHARD;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class CharQuest extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_shard';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo._CharQuest';

    /**
     * The primary key columns.
     *
     * @var array
     */
    protected $primaryKey = ['CharID', 'QuestID'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'CharID', 'QuestID', 'Status', 'AchievementCount', 'StartTime', 'EndTime', 'QuestData1', 'QuestData2'
    ];

    /**
     * Disable auto-incrementing as it's a composite key.
     *
     * @var bool
     */
    public $incrementing = false;

    /**
     * Override the default behavior of `find` to support composite keys.
     */
    public static function findComposite($charID, $questID)
    {
        return self::where('CharID', $charID)->where('QuestID', $questID)->first();
    }

    /**
     * Scope to find records by composite primary key.
     */
    public function scopeFindByCompositeKey(Builder $query, $charID, $questID)
    {
        return $query->where('CharID', $charID)->where('QuestID', $questID);
    }


    // Get Char Quest by CharID and QuestID
    public static function getCharQuest($charID, $questID)
    {
        return self::where('CharID', $charID)->where('QuestID', $questID)->first();
    }
}
