<?php

namespace App\Models\SRO_VT_PROXY_Helper;

use Illuminate\Database\Eloquent\Model;
use App\Models\SRO_VT_SHARD\Char;

class _InstantItemDelivery_3s extends Model
{
    protected $table = '_InstantItemDelivery_3s';
    protected $connection = 'sqlsrv_proxy_helper';
    protected $primaryKey = 'ID';
    public $timestamps = false;

    protected $fillable = [
        'CharID',
        'StorageType',
        'CodeName',
        'Count',
        'Plus',
        'message_type',
        'message',
        'add_date',
        'Got_Item',
        'Got_date',
        'Serial',
    ];

    protected $casts = [
        'CharID' => 'integer',
        'StorageType' => 'integer',
        'Count' => 'integer',
        'Plus' => 'integer',
        'message_type' => 'integer',
        'Got_Item' => 'boolean',
        'add_date' => 'datetime',
        'Got_date' => 'datetime',
        'Serial' => 'integer',
    ];

    // Default values
    protected $attributes = [
        'StorageType' => 0,
        'Plus' => 0,
        'message_type' => 0,
        'Got_Item' => false,
        'Serial' => 0,
    ];

    /**
     * العلاقة مع جدول الشخصيات
     */
    public function character()
    {
        return $this->belongsTo(Char::class, 'CharID', 'CharID');
    }

    /**
     * دالة لإنشاء عنصر جديد للتسليم
     */
    public static function createDelivery(array $data)
    {
        return self::create([
            'CharID' => $data['CharID'],
            'StorageType' => $data['StorageType'] ?? 0, // 0 = Inventory, 1 = Storage
            'CodeName' => $data['CodeName'],
            'Count' => $data['Count'] ?? 1,
            'Plus' => $data['Plus'] ?? 0,
            'message_type' => $data['message_type'] ?? 0,
            'message' => $data['message'] ?? 'Quest Reward',
            'add_date' => now(),
            'Got_Item' => false,
            'Got_date' => null,
            'Serial' => $data['Serial'] ?? 0,
        ]);
    }

}
