<?php

namespace App\Models\SRO_VT_PROXY;

use Illuminate\Database\Eloquent\Model;
use App\Models\Z_Website\User;

class _Players extends Model
{
    protected $table = '_Players';
    protected $connection = 'sqlsrv_proxy';
    protected $primaryKey = 'CharID';
    public $timestamps = false;

    protected $fillable = [
        'CharID',
        'CharName',
        'StrUserID',
        'IP',
        'HWID',
        'Serial',
        'PCName',
        'Mac',
        'cur_status',
        'last_seen',
        'UniqueID',
    ];

    // العلاقة مع جدول المستخدمين
    public function user()
    {
        return $this->belongsTo(User::class, 'StrUserID', 'username');
    }

    // get serial by username or return false if not found
    public static function getSerialByusername($username)
    {
        $player = self::where('StrUserID', $username)->first();
        return $player ? $player->Serial : null;
    }

    //Get Serial By CharID
    public static function getSerialByCharID($charID)
    {
        $player = self::where('CharID', $charID)->first();
        return $player ? $player->Serial : null;
    }
}
