<?php

namespace App\Models\SRO_VT_PROXY;

use Illuminate\Database\Eloquent\Model;

class _AutoNotice extends Model
{
    protected $table = '_AutoNotice';
    protected $connection = 'sqlsrv_proxy';
    protected $primaryKey = 'ID';
    public $timestamps = false;

    protected $fillable = [
        'NoticeType',
        'Message',
        'CHARNAME16',
        'Sent',
        'Time',
    ];

    protected $casts = [
        'NoticeType' => 'integer',
        'Sent' => 'boolean',
        'Time' => 'datetime',
    ];

    // Default values
    protected $attributes = [
        'Sent' => false,
    ];

    /**
     * أنواع الإشعارات
     */
    const NOTICE_TYPES = [
        'SYSTEM' => 1,
        'QUEST_REWARD' => 2,
        'VIP_REWARD' => 3,
        'DAILY_BONUS' => 4,
        'EVENT' => 5,
        'MAINTENANCE' => 6,
        'ACHIEVEMENT' => 7,
    ];

    /**
     * إنشاء إشعار جديد
     */
    public static function sendnotice(array $data)
    {
        return self::create([
            'NoticeType' => $data['NoticeType'],
            'Message' => $data['Message'],
            'CHARNAME16' => $data['CHARNAME16'] ?? null,
            'Sent' => false,
            'Time' => now(),
        ]);
    }

}
