<?php

namespace App\Models\SRO_VT_PROXY;

use App\Models\SRO_VT_SHARD\Char;
use Illuminate\Database\Eloquent\Model;

class OnlineOfflineLog extends Model
{

    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_proxy';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo.Players';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'CharID',
        'cur_status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'cur_status' => 'boolean',
    ];

    /**
     * If the Char is logged in
     */
    const STATUS_LOGGED_IN = true;

    /**
     * If the Char is logged out
     */
    const STATUS_LOGGED_OUT = false;

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function getCharacter()
    {
        return $this->belongsTo(Char::class, 'CharID', 'CharID')
            ->whereNotNull('CharName16')
            ->select(['CharID', 'CharName16', 'CurLevel', 'LatestRegion', 'PosX', 'PosY', 'PosZ']);
    }
}
