<?php

namespace App\Models\SRO_VT_ACCOUNT;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;

class TbUser extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The connection name for the model.
     */
    protected $connection = 'sqlsrv_account';

    /**
     * The table associated with the model.
     */
    protected $table = 'dbo.TB_User';

    /**
     * The primary key associated with the table.
     */
    protected $primaryKey = 'JID';

    /**
     * Indicates if the model should be timestamped.
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'StrUserID',
        'Name',
        'password',
        'Email',
        'Status',
        'GMrank',
        'regtime',
        'reg_ip',
    ];

    /**
     * The attributes that should be hidden for serialization.
     */
    protected $hidden = [
        'password',
    ];

    /**
     * Get the attributes that should be cast.
     */
    protected function casts(): array
    {
        return [
            'password' => 'hashed',
        ];
    }

    /**
     * Get the name of the unique identifier for the user.
     */
    public function getAuthIdentifierName(): string
    {
        return 'StrUserID';
    }

    /**
     * Get the unique identifier for the user.
     */
    public function getAuthIdentifier(): mixed
    {
        return $this->{$this->getAuthIdentifierName()};
    }

    /**
     * Get the password for the user.
     */
    public function getAuthPassword(): string
    {
        return $this->password;
    }

    /**
     * Override password hashing to use MD5
     */
    public function setPasswordAttribute($value): void
    {
        // إذا كانت القيمة already MD5 hash (32 characters), لا نغيرها
        if (strlen($value) === 32 && ctype_xdigit($value)) {
            $this->attributes['password'] = $value;
        } else {
            // إذا كانت plain text, نحولها لـ MD5
            $this->attributes['password'] = md5($value);
        }
    }

    /**
     * علاقة مع SK_Silk
     */
    public function skSilk()
    {
        return $this->hasOne(\App\Models\SRO_VT_ACCOUNT\SkSilk::class, 'JID', 'JID');
    }

    /**
     * علاقة مع جدول الموقع
     */
    public function webUser()
    {
        return $this->hasOne(\App\Models\Z_Website\User::class, 'JID', 'JID');
    }

    /**
     * Get user initials for UI
     */
    public function initials(): string
    {
        $name = $this->Name ?: $this->StrUserID;
        $words = explode(' ', trim($name));

        if (count($words) >= 2) {
            return strtoupper(substr($words[0], 0, 1) . substr($words[1], 0, 1));
        }

        return strtoupper(substr($name, 0, 2));
    }

    /**
     * Get user's display name
     */
    public function getNameAttribute(): string
    {
        return $this->attributes['Name'] ?: $this->StrUserID;
    }
}
