<?php

namespace App\Models\SRO_VT_ACCOUNT;

use Illuminate\Database\Eloquent\Model;

class SkSilk extends Model
{
    /**
     * The Database connection name for the model.
     *
     * @var string
     */
    protected $connection = 'sqlsrv_account';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'dbo.SK_Silk';

    /**
     * The table primary Key
     *
     * @var string JID
     */
    protected $primaryKey = 'JID';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'JID',
        'silk_own',
        'silk_gift',
        'silk_point'
    ];

    // ==============================================
    // RELATIONSHIPS
    // ==============================================

    /**
     * العلاقة العكسية مع TbUser
     * كل سيلك ينتمي لمستخدم واحد
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function tbUser()
    {
        return $this->belongsTo(TbUser::class, 'JID', 'JID');
    }

    /**
     * العلاقة العكسية مع User (موقع)
     * كل سيلك ينتمي لمستخدم واحد في الموقع
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webUser()
    {
        return $this->belongsTo(\App\Models\Z_Website\User::class, 'JID', 'JID');
    }
}
