<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RechargeRewardsSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'tier_name',
        'minimum_amount',
        'rewards',
        'tier_color',
        'tier_icon',
        'description',
        'is_active',
        'sort_order'
    ];

    protected $casts = [
        'rewards' => 'array',
        'minimum_amount' => 'decimal:2',
        'is_active' => 'boolean'
    ];

    /**
     * Get active reward tiers ordered by minimum amount
     */
    public static function getActiveTiers()
    {
        return self::where('is_active', true)
                   ->orderBy('minimum_amount')
                   ->get();
    }

    /**
     * Get the appropriate tier for a given total recharge amount
     */
    public static function getTierForAmount($totalAmount)
    {
        return self::where('is_active', true)
                   ->where('minimum_amount', '<=', $totalAmount)
                   ->orderBy('minimum_amount', 'desc')
                   ->first();
    }

    /**
     * Get the next tier for progression
     */
    public static function getNextTierForAmount($totalAmount)
    {
        return self::where('is_active', true)
                   ->where('minimum_amount', '>', $totalAmount)
                   ->orderBy('minimum_amount')
                   ->first();
    }

    /**
     * Get rewards relationship
     */
    public function rewards()
    {
        return $this->hasMany(RechargeReward::class, 'reward_setting_id');
    }
}
