<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class FastEvent extends Model
{
    use HasFactory;

    protected $table = 'fast_events';

    protected $fillable = [
        'event_name',
        'is_active',
        'expired_at',
        'blade_name'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'expired_at' => 'datetime'
    ];

    // Scope for active events
    public function scopeActive($query)
    {
        return $query->where('is_active', true)
                    ->where('expired_at', '>', Carbon::now());
    }

    // Check if event is expired
    public function getIsExpiredAttribute()
    {
        return $this->expired_at ? Carbon::now()->gt($this->expired_at) : false;
    }

    // Auto-disable expired events
    public function checkAndDisableIfExpired()
    {
        if ($this->is_expired && $this->is_active) {
            $this->update(['is_active' => false]);
            return true;
        }
        return false;
    }
}
