<?php

namespace App\Models\DuckSoup;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CharChestLog extends Model
{
    use HasFactory;

    protected $connection = 'sqlsrv_proxy';
    protected $table = 'CharChestLog';
    protected $primaryKey = 'ID';
    public $timestamps = false;

    protected $fillable = [
        'CharID',
        'RefItemID',
        'Count',
        'OptLevel',
        'RandomizedStats',
        'RewardFrom',
        'RegisterTime',
        'Action',
    ];

    protected $casts = [
        'RegisterTime' => 'datetime',
    ];
}
