<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Helpers\LanguageHelper;
use Illuminate\Support\Facades\App;

class SetApplicationLanguage
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // تحديد اللغة المناسبة للمستخدم
        $userLanguage = LanguageHelper::determineUserLanguage();

        // تطبيق اللغة على Laravel
        App::setLocale($userLanguage);

        // إضافة اللغة إلى request للاستخدام لاحقاً
        $request->attributes->set('user_language', $userLanguage);

        return $next($request);
    }
}
