<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class LoadUserSessionData
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $user = Auth::user();

            // تحقق إذا كانت البيانات غير موجودة في الجلسة
            if (!session()->has('user_session_data')) {
                try {
                    // تحميل بيانات SkSilk
                    $silkData = $user->skSilk;

                    // تحميل بيانات الموقع
                    $webUser = $user->webUser;

                    // حفظ البيانات في الجلسة
                    session([
                        'user_session_data' => [
                            'JID' => $user->JID,
                            'StrUserID' => $user->StrUserID,
                            'Name' => $user->Name,
                            'Email' => $user->Email,
                            'GMrank' => $user->GMrank,
                            'Status' => $user->Status,
                        ],
                        'silk_data' => [
                            'silk_own' => $silkData->silk_own ?? 0,
                            'silk_gift' => $silkData->silk_gift ?? 0,
                            'silk_point' => $silkData->silk_point ?? 0,
                            'total_silk' => ($silkData->silk_own ?? 0) + ($silkData->silk_gift ?? 0),
                        ],
                        'web_user_data' => [
                            'balance' => $webUser->balance ?? 0,
                            'referrer_id' => $webUser->referrer_id ?? null,
                            'created_at' => $webUser->created_at ?? null,
                        ],
                        'user_stats' => [
                            'last_login' => now(),
                            'is_online' => true,
                            'total_characters' => 0, // يمكن إضافة عدد الشخصيات لاحقاً
                        ]
                    ]);
                } catch (\Exception $e) {
                    // في حالة خطأ، احفظ بيانات أساسية فقط
                    session([
                        'user_session_data' => [
                            'JID' => $user->JID,
                            'StrUserID' => $user->StrUserID,
                            'Name' => $user->Name,
                            'Email' => $user->Email,
                            'GMrank' => $user->GMrank ?? 0,
                            'Status' => $user->Status ?? 1,
                        ]
                    ]);
                }
            }
        }

        return $next($request);
    }
}
