<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!Auth::check()) {
            // إذا كان المستخدم غير مسجل دخول، أعد توجيهه للصفحة الرئيسية
            return redirect()->route('home')->with('error', 'يجب تسجيل الدخول للوصول لهذه الصفحة');
        }

        return $next($request);
    }
}
