<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\InventoryHelper;

class TestInventoryController extends Controller
{
    /**
     * Test inventory system with sample data
     */
    public function test()
    {
        // Sample character ID for testing
        $testCharId = 1; // Replace with actual character ID from your database

        try {
            // Test equipment retrieval
            $equipment = InventoryHelper::getCharacterEquipment($testCharId);

            // Enhanced sample test data to simulate real items with actual paths
            $testEquipment = [
                [
                    'slot' => 6,
                    'item_id' => '12345',
                    'name' => 'Test Sword +9',
                    'icon_path' => 'item/1.ddj', // This should exist as item/1.jpg
                    'rarity' => 4,
                    'opt_level' => 9
                ],
                [
                    'slot' => 0,
                    'item_id' => '12346',
                    'name' => 'Dragon Helmet',
                    'icon_path' => 'item/2.ddj', // This should exist as item/2.jpg
                    'rarity' => 3,
                    'opt_level' => 5
                ],
                [
                    'slot' => 1,
                    'item_id' => '12347',
                    'name' => 'Steel Armor',
                    'icon_path' => 'item/3.ddj', // This should exist as item/3.jpg
                    'rarity' => 2,
                    'opt_level' => 0
                ],
                [
                    'slot' => 7,
                    'item_id' => '12348',
                    'name' => 'Magic Shield',
                    'icon_path' => 'item/4.ddj', // This should exist as item/4.jpg
                    'rarity' => 3,
                    'opt_level' => 3
                ]
            ];

            return view('test.inventory', [
                'charId' => $testCharId,
                'equipment' => $testEquipment,
                'realEquipment' => $equipment,
                'debugInfo' => [
                    'test_items_count' => count($testEquipment),
                    'real_items_count' => count($equipment),
                    'database_connection' => config('database.connections.sqlsrv_shard.host') ?? 'Not configured'
                ]
            ]);

        } catch (\Exception $e) {
            return view('test.inventory', [
                'charId' => $testCharId,
                'equipment' => [],
                'realEquipment' => [],
                'error' => $e->getMessage(),
                'debugInfo' => [
                    'error_type' => get_class($e),
                    'error_file' => $e->getFile(),
                    'error_line' => $e->getLine()
                ]
            ]);
        }
    }    /**
     * Test API endpoint
     */
    public function testApi($charId = 1)
    {
        try {
            $equipment = InventoryHelper::getCharacterEquipment($charId);

            $processedEquipment = [];
            foreach ($equipment as $item) {
                $processedEquipment[] = [
                    'slot' => $item['slot'],
                    'item_id' => $item['item_id'],
                    'name' => $item['name'],
                    'icon_path' => $item['icon_path'],
                    'image_url' => InventoryHelper::processIconPath($item['icon_path']),
                    'rarity' => $item['rarity'],
                    'grade' => InventoryHelper::getItemGrade($item['rarity']),
                    'opt_level' => $item['opt_level'],
                    'slot_name' => InventoryHelper::getSlotName($item['slot'])
                ];
            }

            return response()->json([
                'success' => true,
                'data' => [
                    'character_id' => $charId,
                    'equipment' => $processedEquipment,
                    'slots_info' => [
                        'total_slots' => 13,
                        'equipped_slots' => count($processedEquipment),
                        'empty_slots' => 13 - count($processedEquipment)
                    ]
                ]
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }
}
