<?php

/**
 * مثال على كيفية استخدام نظام SiteSettings الجديد
 *
 * يمكن استخدام هذه الدوال في أي مكان في التطبيق:
 * - Livewire Components
 * - Blade Templates
 * - Controllers
 * - API Routes
 */

// === استخدام الدوال المساعدة العامة ===

// 1. الحصول على جميع الإعدادات منسقة
$allSettings = siteSettings();

// 2. الحصول على إعداد معين
$facebookUrl = siteSettings('facebook_url', '#');
$maxServer = siteSettings('sro_max_server', '1000');

// 3. الحصول على الروابط الاجتماعية
$social = socialLinks();
/*
Array:
[
    'facebook' => 'https://www.facebook.com/gaming/4TresSro/',
    'youtube' => 'https://www.youtube.com/@4tresSro',
    'discord_id' => '1088967719782715404',
    'contact_email' => '4tressro@gmail.com'
]
*/

// 4. الحصول على معدلات الخادم
$rates = serverRates();
/*
Array:
[
    'exp' => '45',
    'gold' => '45',
    'drop' => '45',
    'job' => '40',
    'party' => '55'
]
*/

// 5. الحصول على حدود الخادم
$limits = serverLimits();
/*
Array:
[
    'max_server' => '1000',
    'level_cap' => '130',
    'ip_limit' => '99',
    'hwid_limit' => '8'
]
*/

// === استخدام الكلاس المساعد مباشرة ===

use App\Helpers\SiteSettingsHelper;

// الحصول على حالة الحصون
$fortressStatus = SiteSettingsHelper::getFortressStatus();
/*
Array:
[
    'jangan' => true,
    'bandit' => true,
    'hotan' => false,
    'constantinople' => true
]
*/

// الحصول على حالة أنظمة الترتيب
$ranking = SiteSettingsHelper::getRankingStatus();
/*
Array:
[
    'char_ranking' => true,
    'guild_ranking' => true,
    'job_ranking' => true,
    // ... etc
]
*/

// التحقق من حالة التسجيل
$isOpen = SiteSettingsHelper::isRegistrationOpen();

// الحصول على أسماء العملات
$currency = SiteSettingsHelper::getCurrencyNames();
/*
Array:
[
    'silk' => 'Silk',
    'silk_gift' => '4T Donate'
]
*/

// === استخدام في Blade Templates ===

/*
في ملفات Blade يمكن استخدام:

<!-- الحصول على رابط فيسبوك -->
<a href="{{ siteSettings('facebook_url', '#') }}">Facebook</a>

<!-- عرض معدل التجربة -->
<span>EXP Rate: {{ serverRates()['exp'] }}x</span>

<!-- عرض حد اللاعبين -->
<span>Max Players: {{ serverLimits()['max_server'] }}</span>

<!-- التحقق من حالة التسجيل -->
@if(App\Helpers\SiteSettingsHelper::isRegistrationOpen())
    <a href="/register">Register Now</a>
@else
    <span>Registration Closed</span>
@endif
*/

// === استخدام في Livewire Components ===

/*
في Livewire Components:

public function mount()
{
    $this->socialLinks = socialLinks();
    $this->serverRates = serverRates();
    $this->maxPlayers = siteSettings('sro_max_server', '1000');
}

public function getFacebookUrl()
{
    return siteSettings('facebook_url', '#');
}
*/

// === مسح الكاش ===

// عند تحديث الإعدادات، يجب مسح الكاش
SiteSettingsHelper::clearCache();

// === الفوائد الرئيسية ===

/*
1. سهولة الوصول من أي مكان
2. تخزين مؤقت للأداء العالي
3. قيم افتراضية آمنة
4. تنسيق مسبق للبيانات
5. إمكانية الاستخدام في Blade و Livewire
6. تجميع المعلومات ذات الصلة
7. سهولة الصيانة والتطوير
*/
